/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.custom.StyleRange;

public class NonRuleBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument fDocument;
    protected IToken fDefaultTextAttribute;
    private String fFullScope;

    public NonRuleBasedDamagerRepairer(IToken defaultTextAttribute) {
        Assert.isNotNull((Object)defaultTextAttribute);
        this.fDefaultTextAttribute = defaultTextAttribute;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    protected int endOfLineOf(int offset) throws BadLocationException {
        IRegion info = this.fDocument.getLineInformationOfOffset(offset);
        if (offset <= info.getOffset() + info.getLength()) {
            return info.getOffset() + info.getLength();
        }
        int line = this.fDocument.getLineOfOffset(offset);
        try {
            info = this.fDocument.getLineInformation(line + 1);
            return info.getOffset() + info.getLength();
        }
        catch (BadLocationException x) {
            return this.fDocument.getLength();
        }
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        if (!documentPartitioningChanged) {
            try {
                IRegion info = this.fDocument.getLineInformationOfOffset(event.getOffset());
                int start = Math.max(partition.getOffset(), info.getOffset());
                int end = event.getOffset() + (event.getText() == null ? event.getLength() : event.getText().length());
                end = info.getOffset() <= end && end <= info.getOffset() + info.getLength() ? info.getOffset() + info.getLength() : this.endOfLineOf(end);
                end = Math.min(partition.getOffset() + partition.getLength(), end);
                return new Region(start, end - start);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        this.wipeExistingScopes(region);
        Object object = NonRuleBasedDamagerRepairer.getLockObject(this.fDocument);
        synchronized (object) {
            try {
                this.fDocument.addPositionCategory("scopes");
                this.fDocument.addPosition("scopes", (Position)new TypedPosition(region.getOffset(), region.getLength(), (String)this.fDefaultTextAttribute.getData()));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        this.addRange(presentation, region.getOffset(), region.getLength(), this.getTextAttribute(region));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wipeExistingScopes(ITypedRegion region) {
        int offset = region.getOffset();
        int end = offset + region.getLength();
        try {
            Object object = NonRuleBasedDamagerRepairer.getLockObject(this.fDocument);
            synchronized (object) {
                int stop;
                int start;
                Position[] positions;
                this.fDocument.addPositionCategory("scopes");
                int index = this.fDocument.computeIndexInCategory("scopes", offset);
                int endIndex = this.fDocument.computeIndexInCategory("scopes", end);
                if (endIndex == index) {
                    return;
                }
                if (this.fDocument instanceof AbstractDocument) {
                    AbstractDocument abDoc = (AbstractDocument)this.fDocument;
                    positions = abDoc.getPositions("scopes", offset, region.getLength(), false, false);
                    start = 0;
                    stop = positions.length;
                } else {
                    positions = this.fDocument.getPositions("scopes");
                    start = index;
                    stop = endIndex;
                }
                int i = start;
                while (i < stop) {
                    this.fDocument.removePosition("scopes", positions[i]);
                    ++i;
                }
            }
        }
        catch (BadPositionCategoryException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)e.getMessage());
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)e.getMessage());
        }
    }

    private static Object getLockObject(Object object) {
        Object lock;
        if (object instanceof ISynchronizable && (lock = ((ISynchronizable)object).getLockObject()) != null) {
            return lock;
        }
        return object;
    }

    protected TextAttribute getTextAttribute(ITypedRegion region) {
        Object data = this.fDefaultTextAttribute.getData();
        if (data instanceof String) {
            if (this.fFullScope == null) {
                try {
                    String last = (String)data;
                    int offset = region.getOffset();
                    String scope = this.getDocumentScopeManager().getScopeAtOffset(this.fDocument, offset);
                    if (last.length() == 0) {
                        last = scope;
                    } else if (!scope.endsWith(last)) {
                        scope = String.valueOf(scope) + ' ' + last;
                    }
                    this.fFullScope = scope;
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
            IToken token = this.getThemeManager().getToken(this.fFullScope);
            data = token.getData();
        }
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return null;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            presentation.addStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
        }
    }

    protected IDocumentScopeManager getDocumentScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }
}

